# generated from rosidl_generator_py/resource/_idl.py.em
# with input from novatel_gps_msgs:msg/NovatelUtmPosition.idl
# generated code does not contain a copyright notice


# Import statements for member types

import builtins  # noqa: E402, I100

import math  # noqa: E402, I100

import rosidl_parser.definition  # noqa: E402, I100


class Metaclass_NovatelUtmPosition(type):
    """Metaclass of message 'NovatelUtmPosition'."""

    _CREATE_ROS_MESSAGE = None
    _CONVERT_FROM_PY = None
    _CONVERT_TO_PY = None
    _DESTROY_ROS_MESSAGE = None
    _TYPE_SUPPORT = None

    __constants = {
    }

    @classmethod
    def __import_type_support__(cls):
        try:
            from rosidl_generator_py import import_type_support
            module = import_type_support('novatel_gps_msgs')
        except ImportError:
            import logging
            import traceback
            logger = logging.getLogger(
                'novatel_gps_msgs.msg.NovatelUtmPosition')
            logger.debug(
                'Failed to import needed modules for type support:\n' +
                traceback.format_exc())
        else:
            cls._CREATE_ROS_MESSAGE = module.create_ros_message_msg__msg__novatel_utm_position
            cls._CONVERT_FROM_PY = module.convert_from_py_msg__msg__novatel_utm_position
            cls._CONVERT_TO_PY = module.convert_to_py_msg__msg__novatel_utm_position
            cls._TYPE_SUPPORT = module.type_support_msg__msg__novatel_utm_position
            cls._DESTROY_ROS_MESSAGE = module.destroy_ros_message_msg__msg__novatel_utm_position

            from novatel_gps_msgs.msg import NovatelExtendedSolutionStatus
            if NovatelExtendedSolutionStatus.__class__._TYPE_SUPPORT is None:
                NovatelExtendedSolutionStatus.__class__.__import_type_support__()

            from novatel_gps_msgs.msg import NovatelMessageHeader
            if NovatelMessageHeader.__class__._TYPE_SUPPORT is None:
                NovatelMessageHeader.__class__.__import_type_support__()

            from novatel_gps_msgs.msg import NovatelSignalMask
            if NovatelSignalMask.__class__._TYPE_SUPPORT is None:
                NovatelSignalMask.__class__.__import_type_support__()

            from std_msgs.msg import Header
            if Header.__class__._TYPE_SUPPORT is None:
                Header.__class__.__import_type_support__()

    @classmethod
    def __prepare__(cls, name, bases, **kwargs):
        # list constant names here so that they appear in the help text of
        # the message class under "Data and other attributes defined here:"
        # as well as populate each message instance
        return {
        }


class NovatelUtmPosition(metaclass=Metaclass_NovatelUtmPosition):
    """Message class 'NovatelUtmPosition'."""

    __slots__ = [
        '_header',
        '_novatel_msg_header',
        '_solution_status',
        '_position_type',
        '_lon_zone_number',
        '_lat_zone_letter',
        '_northing',
        '_easting',
        '_height',
        '_undulation',
        '_datum_id',
        '_northing_sigma',
        '_easting_sigma',
        '_height_sigma',
        '_base_station_id',
        '_diff_age',
        '_solution_age',
        '_num_satellites_tracked',
        '_num_satellites_used_in_solution',
        '_num_gps_and_glonass_l1_used_in_solution',
        '_num_gps_and_glonass_l1_and_l2_used_in_solution',
        '_extended_solution_status',
        '_signal_mask',
    ]

    _fields_and_field_types = {
        'header': 'std_msgs/Header',
        'novatel_msg_header': 'novatel_gps_msgs/NovatelMessageHeader',
        'solution_status': 'string',
        'position_type': 'string',
        'lon_zone_number': 'uint32',
        'lat_zone_letter': 'string',
        'northing': 'double',
        'easting': 'double',
        'height': 'double',
        'undulation': 'float',
        'datum_id': 'string',
        'northing_sigma': 'float',
        'easting_sigma': 'float',
        'height_sigma': 'float',
        'base_station_id': 'string',
        'diff_age': 'float',
        'solution_age': 'float',
        'num_satellites_tracked': 'uint8',
        'num_satellites_used_in_solution': 'uint8',
        'num_gps_and_glonass_l1_used_in_solution': 'uint8',
        'num_gps_and_glonass_l1_and_l2_used_in_solution': 'uint8',
        'extended_solution_status': 'novatel_gps_msgs/NovatelExtendedSolutionStatus',
        'signal_mask': 'novatel_gps_msgs/NovatelSignalMask',
    }

    SLOT_TYPES = (
        rosidl_parser.definition.NamespacedType(['std_msgs', 'msg'], 'Header'),  # noqa: E501
        rosidl_parser.definition.NamespacedType(['novatel_gps_msgs', 'msg'], 'NovatelMessageHeader'),  # noqa: E501
        rosidl_parser.definition.UnboundedString(),  # noqa: E501
        rosidl_parser.definition.UnboundedString(),  # noqa: E501
        rosidl_parser.definition.BasicType('uint32'),  # noqa: E501
        rosidl_parser.definition.UnboundedString(),  # noqa: E501
        rosidl_parser.definition.BasicType('double'),  # noqa: E501
        rosidl_parser.definition.BasicType('double'),  # noqa: E501
        rosidl_parser.definition.BasicType('double'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.UnboundedString(),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.UnboundedString(),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.BasicType('uint8'),  # noqa: E501
        rosidl_parser.definition.BasicType('uint8'),  # noqa: E501
        rosidl_parser.definition.BasicType('uint8'),  # noqa: E501
        rosidl_parser.definition.BasicType('uint8'),  # noqa: E501
        rosidl_parser.definition.NamespacedType(['novatel_gps_msgs', 'msg'], 'NovatelExtendedSolutionStatus'),  # noqa: E501
        rosidl_parser.definition.NamespacedType(['novatel_gps_msgs', 'msg'], 'NovatelSignalMask'),  # noqa: E501
    )

    def __init__(self, **kwargs):
        assert all('_' + key in self.__slots__ for key in kwargs.keys()), \
            'Invalid arguments passed to constructor: %s' % \
            ', '.join(sorted(k for k in kwargs.keys() if '_' + k not in self.__slots__))
        from std_msgs.msg import Header
        self.header = kwargs.get('header', Header())
        from novatel_gps_msgs.msg import NovatelMessageHeader
        self.novatel_msg_header = kwargs.get('novatel_msg_header', NovatelMessageHeader())
        self.solution_status = kwargs.get('solution_status', str())
        self.position_type = kwargs.get('position_type', str())
        self.lon_zone_number = kwargs.get('lon_zone_number', int())
        self.lat_zone_letter = kwargs.get('lat_zone_letter', str())
        self.northing = kwargs.get('northing', float())
        self.easting = kwargs.get('easting', float())
        self.height = kwargs.get('height', float())
        self.undulation = kwargs.get('undulation', float())
        self.datum_id = kwargs.get('datum_id', str())
        self.northing_sigma = kwargs.get('northing_sigma', float())
        self.easting_sigma = kwargs.get('easting_sigma', float())
        self.height_sigma = kwargs.get('height_sigma', float())
        self.base_station_id = kwargs.get('base_station_id', str())
        self.diff_age = kwargs.get('diff_age', float())
        self.solution_age = kwargs.get('solution_age', float())
        self.num_satellites_tracked = kwargs.get('num_satellites_tracked', int())
        self.num_satellites_used_in_solution = kwargs.get('num_satellites_used_in_solution', int())
        self.num_gps_and_glonass_l1_used_in_solution = kwargs.get('num_gps_and_glonass_l1_used_in_solution', int())
        self.num_gps_and_glonass_l1_and_l2_used_in_solution = kwargs.get('num_gps_and_glonass_l1_and_l2_used_in_solution', int())
        from novatel_gps_msgs.msg import NovatelExtendedSolutionStatus
        self.extended_solution_status = kwargs.get('extended_solution_status', NovatelExtendedSolutionStatus())
        from novatel_gps_msgs.msg import NovatelSignalMask
        self.signal_mask = kwargs.get('signal_mask', NovatelSignalMask())

    def __repr__(self):
        typename = self.__class__.__module__.split('.')
        typename.pop()
        typename.append(self.__class__.__name__)
        args = []
        for s, t in zip(self.__slots__, self.SLOT_TYPES):
            field = getattr(self, s)
            fieldstr = repr(field)
            # We use Python array type for fields that can be directly stored
            # in them, and "normal" sequences for everything else.  If it is
            # a type that we store in an array, strip off the 'array' portion.
            if (
                isinstance(t, rosidl_parser.definition.AbstractSequence) and
                isinstance(t.value_type, rosidl_parser.definition.BasicType) and
                t.value_type.typename in ['float', 'double', 'int8', 'uint8', 'int16', 'uint16', 'int32', 'uint32', 'int64', 'uint64']
            ):
                if len(field) == 0:
                    fieldstr = '[]'
                else:
                    assert fieldstr.startswith('array(')
                    prefix = "array('X', "
                    suffix = ')'
                    fieldstr = fieldstr[len(prefix):-len(suffix)]
            args.append(s[1:] + '=' + fieldstr)
        return '%s(%s)' % ('.'.join(typename), ', '.join(args))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        if self.header != other.header:
            return False
        if self.novatel_msg_header != other.novatel_msg_header:
            return False
        if self.solution_status != other.solution_status:
            return False
        if self.position_type != other.position_type:
            return False
        if self.lon_zone_number != other.lon_zone_number:
            return False
        if self.lat_zone_letter != other.lat_zone_letter:
            return False
        if self.northing != other.northing:
            return False
        if self.easting != other.easting:
            return False
        if self.height != other.height:
            return False
        if self.undulation != other.undulation:
            return False
        if self.datum_id != other.datum_id:
            return False
        if self.northing_sigma != other.northing_sigma:
            return False
        if self.easting_sigma != other.easting_sigma:
            return False
        if self.height_sigma != other.height_sigma:
            return False
        if self.base_station_id != other.base_station_id:
            return False
        if self.diff_age != other.diff_age:
            return False
        if self.solution_age != other.solution_age:
            return False
        if self.num_satellites_tracked != other.num_satellites_tracked:
            return False
        if self.num_satellites_used_in_solution != other.num_satellites_used_in_solution:
            return False
        if self.num_gps_and_glonass_l1_used_in_solution != other.num_gps_and_glonass_l1_used_in_solution:
            return False
        if self.num_gps_and_glonass_l1_and_l2_used_in_solution != other.num_gps_and_glonass_l1_and_l2_used_in_solution:
            return False
        if self.extended_solution_status != other.extended_solution_status:
            return False
        if self.signal_mask != other.signal_mask:
            return False
        return True

    @classmethod
    def get_fields_and_field_types(cls):
        from copy import copy
        return copy(cls._fields_and_field_types)

    @builtins.property
    def header(self):
        """Message field 'header'."""
        return self._header

    @header.setter
    def header(self, value):
        if __debug__:
            from std_msgs.msg import Header
            assert \
                isinstance(value, Header), \
                "The 'header' field must be a sub message of type 'Header'"
        self._header = value

    @builtins.property
    def novatel_msg_header(self):
        """Message field 'novatel_msg_header'."""
        return self._novatel_msg_header

    @novatel_msg_header.setter
    def novatel_msg_header(self, value):
        if __debug__:
            from novatel_gps_msgs.msg import NovatelMessageHeader
            assert \
                isinstance(value, NovatelMessageHeader), \
                "The 'novatel_msg_header' field must be a sub message of type 'NovatelMessageHeader'"
        self._novatel_msg_header = value

    @builtins.property
    def solution_status(self):
        """Message field 'solution_status'."""
        return self._solution_status

    @solution_status.setter
    def solution_status(self, value):
        if __debug__:
            assert \
                isinstance(value, str), \
                "The 'solution_status' field must be of type 'str'"
        self._solution_status = value

    @builtins.property
    def position_type(self):
        """Message field 'position_type'."""
        return self._position_type

    @position_type.setter
    def position_type(self, value):
        if __debug__:
            assert \
                isinstance(value, str), \
                "The 'position_type' field must be of type 'str'"
        self._position_type = value

    @builtins.property
    def lon_zone_number(self):
        """Message field 'lon_zone_number'."""
        return self._lon_zone_number

    @lon_zone_number.setter
    def lon_zone_number(self, value):
        if __debug__:
            assert \
                isinstance(value, int), \
                "The 'lon_zone_number' field must be of type 'int'"
            assert value >= 0 and value < 4294967296, \
                "The 'lon_zone_number' field must be an unsigned integer in [0, 4294967295]"
        self._lon_zone_number = value

    @builtins.property
    def lat_zone_letter(self):
        """Message field 'lat_zone_letter'."""
        return self._lat_zone_letter

    @lat_zone_letter.setter
    def lat_zone_letter(self, value):
        if __debug__:
            assert \
                isinstance(value, str), \
                "The 'lat_zone_letter' field must be of type 'str'"
        self._lat_zone_letter = value

    @builtins.property
    def northing(self):
        """Message field 'northing'."""
        return self._northing

    @northing.setter
    def northing(self, value):
        if __debug__:
            assert \
                isinstance(value, float), \
                "The 'northing' field must be of type 'float'"
            assert not (value < -1.7976931348623157e+308 or value > 1.7976931348623157e+308) or math.isinf(value), \
                "The 'northing' field must be a double in [-1.7976931348623157e+308, 1.7976931348623157e+308]"
        self._northing = value

    @builtins.property
    def easting(self):
        """Message field 'easting'."""
        return self._easting

    @easting.setter
    def easting(self, value):
        if __debug__:
            assert \
                isinstance(value, float), \
                "The 'easting' field must be of type 'float'"
            assert not (value < -1.7976931348623157e+308 or value > 1.7976931348623157e+308) or math.isinf(value), \
                "The 'easting' field must be a double in [-1.7976931348623157e+308, 1.7976931348623157e+308]"
        self._easting = value

    @builtins.property
    def height(self):
        """Message field 'height'."""
        return self._height

    @height.setter
    def height(self, value):
        if __debug__:
            assert \
                isinstance(value, float), \
                "The 'height' field must be of type 'float'"
            assert not (value < -1.7976931348623157e+308 or value > 1.7976931348623157e+308) or math.isinf(value), \
                "The 'height' field must be a double in [-1.7976931348623157e+308, 1.7976931348623157e+308]"
        self._height = value

    @builtins.property
    def undulation(self):
        """Message field 'undulation'."""
        return self._undulation

    @undulation.setter
    def undulation(self, value):
        if __debug__:
            assert \
                isinstance(value, float), \
                "The 'undulation' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'undulation' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._undulation = value

    @builtins.property
    def datum_id(self):
        """Message field 'datum_id'."""
        return self._datum_id

    @datum_id.setter
    def datum_id(self, value):
        if __debug__:
            assert \
                isinstance(value, str), \
                "The 'datum_id' field must be of type 'str'"
        self._datum_id = value

    @builtins.property
    def northing_sigma(self):
        """Message field 'northing_sigma'."""
        return self._northing_sigma

    @northing_sigma.setter
    def northing_sigma(self, value):
        if __debug__:
            assert \
                isinstance(value, float), \
                "The 'northing_sigma' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'northing_sigma' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._northing_sigma = value

    @builtins.property
    def easting_sigma(self):
        """Message field 'easting_sigma'."""
        return self._easting_sigma

    @easting_sigma.setter
    def easting_sigma(self, value):
        if __debug__:
            assert \
                isinstance(value, float), \
                "The 'easting_sigma' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'easting_sigma' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._easting_sigma = value

    @builtins.property
    def height_sigma(self):
        """Message field 'height_sigma'."""
        return self._height_sigma

    @height_sigma.setter
    def height_sigma(self, value):
        if __debug__:
            assert \
                isinstance(value, float), \
                "The 'height_sigma' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'height_sigma' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._height_sigma = value

    @builtins.property
    def base_station_id(self):
        """Message field 'base_station_id'."""
        return self._base_station_id

    @base_station_id.setter
    def base_station_id(self, value):
        if __debug__:
            assert \
                isinstance(value, str), \
                "The 'base_station_id' field must be of type 'str'"
        self._base_station_id = value

    @builtins.property
    def diff_age(self):
        """Message field 'diff_age'."""
        return self._diff_age

    @diff_age.setter
    def diff_age(self, value):
        if __debug__:
            assert \
                isinstance(value, float), \
                "The 'diff_age' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'diff_age' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._diff_age = value

    @builtins.property
    def solution_age(self):
        """Message field 'solution_age'."""
        return self._solution_age

    @solution_age.setter
    def solution_age(self, value):
        if __debug__:
            assert \
                isinstance(value, float), \
                "The 'solution_age' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'solution_age' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._solution_age = value

    @builtins.property
    def num_satellites_tracked(self):
        """Message field 'num_satellites_tracked'."""
        return self._num_satellites_tracked

    @num_satellites_tracked.setter
    def num_satellites_tracked(self, value):
        if __debug__:
            assert \
                isinstance(value, int), \
                "The 'num_satellites_tracked' field must be of type 'int'"
            assert value >= 0 and value < 256, \
                "The 'num_satellites_tracked' field must be an unsigned integer in [0, 255]"
        self._num_satellites_tracked = value

    @builtins.property
    def num_satellites_used_in_solution(self):
        """Message field 'num_satellites_used_in_solution'."""
        return self._num_satellites_used_in_solution

    @num_satellites_used_in_solution.setter
    def num_satellites_used_in_solution(self, value):
        if __debug__:
            assert \
                isinstance(value, int), \
                "The 'num_satellites_used_in_solution' field must be of type 'int'"
            assert value >= 0 and value < 256, \
                "The 'num_satellites_used_in_solution' field must be an unsigned integer in [0, 255]"
        self._num_satellites_used_in_solution = value

    @builtins.property
    def num_gps_and_glonass_l1_used_in_solution(self):
        """Message field 'num_gps_and_glonass_l1_used_in_solution'."""
        return self._num_gps_and_glonass_l1_used_in_solution

    @num_gps_and_glonass_l1_used_in_solution.setter
    def num_gps_and_glonass_l1_used_in_solution(self, value):
        if __debug__:
            assert \
                isinstance(value, int), \
                "The 'num_gps_and_glonass_l1_used_in_solution' field must be of type 'int'"
            assert value >= 0 and value < 256, \
                "The 'num_gps_and_glonass_l1_used_in_solution' field must be an unsigned integer in [0, 255]"
        self._num_gps_and_glonass_l1_used_in_solution = value

    @builtins.property
    def num_gps_and_glonass_l1_and_l2_used_in_solution(self):
        """Message field 'num_gps_and_glonass_l1_and_l2_used_in_solution'."""
        return self._num_gps_and_glonass_l1_and_l2_used_in_solution

    @num_gps_and_glonass_l1_and_l2_used_in_solution.setter
    def num_gps_and_glonass_l1_and_l2_used_in_solution(self, value):
        if __debug__:
            assert \
                isinstance(value, int), \
                "The 'num_gps_and_glonass_l1_and_l2_used_in_solution' field must be of type 'int'"
            assert value >= 0 and value < 256, \
                "The 'num_gps_and_glonass_l1_and_l2_used_in_solution' field must be an unsigned integer in [0, 255]"
        self._num_gps_and_glonass_l1_and_l2_used_in_solution = value

    @builtins.property
    def extended_solution_status(self):
        """Message field 'extended_solution_status'."""
        return self._extended_solution_status

    @extended_solution_status.setter
    def extended_solution_status(self, value):
        if __debug__:
            from novatel_gps_msgs.msg import NovatelExtendedSolutionStatus
            assert \
                isinstance(value, NovatelExtendedSolutionStatus), \
                "The 'extended_solution_status' field must be a sub message of type 'NovatelExtendedSolutionStatus'"
        self._extended_solution_status = value

    @builtins.property
    def signal_mask(self):
        """Message field 'signal_mask'."""
        return self._signal_mask

    @signal_mask.setter
    def signal_mask(self, value):
        if __debug__:
            from novatel_gps_msgs.msg import NovatelSignalMask
            assert \
                isinstance(value, NovatelSignalMask), \
                "The 'signal_mask' field must be a sub message of type 'NovatelSignalMask'"
        self._signal_mask = value
